/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.common.worldgen.trees.mangrove;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import teamdraco.unnamedanimalmod.common.worldgen.trees.mangrove.Entry;
import teamdraco.unnamedanimalmod.common.worldgen.trees.mangrove.MangroveTreeHelper;
import teamdraco.unnamedanimalmod.init.UAMBlocks;

public class MangroveLandTreeFeature
extends Feature<NoFeatureConfig> {
    public MangroveLandTreeFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean place(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        Direction[] directions;
        if (reader.func_175623_d(pos.func_177977_b()) || reader.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof LeavesBlock) {
            return false;
        }
        if (reader.func_201671_F(pos) || reader.func_201671_F(pos.func_177977_b())) {
            return false;
        }
        BlockState defaultLog = ((Block)UAMBlocks.MANGROVE_LOG.get()).func_176223_P();
        ArrayList<Entry> filler = new ArrayList<Entry>();
        ArrayList<Entry> leavesFiller = new ArrayList<Entry>();
        int trunkHeight = MangroveTreeHelper.minimumLandTrunkHeight + rand.nextInt(MangroveTreeHelper.landTrunkHeightExtra + 1);
        BlockPos trunkTop = pos.func_177981_b(trunkHeight);
        for (int i = 0; i <= trunkHeight; ++i) {
            Direction[] trunkPos = pos.func_177981_b(i);
            if (!MangroveTreeHelper.canPlace(reader, (BlockPos)trunkPos)) {
                return false;
            }
            filler.add(new Entry((BlockPos)trunkPos, defaultLog));
        }
        MangroveTreeHelper.makeLeafBlob(leavesFiller, rand, pos, trunkHeight);
        block1: for (Direction direction : directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}) {
            BlockPos trunkPos;
            int i;
            int sideTrunkHeight = MangroveTreeHelper.minimumSideLandTrunkHeight + rand.nextInt(MangroveTreeHelper.sideLandTrunkHeightExtra + 1);
            for (i = 0; i <= sideTrunkHeight; ++i) {
                trunkPos = pos.func_177972_a(direction).func_177981_b(i);
                if (!MangroveTreeHelper.canPlace(reader, trunkPos)) {
                    return false;
                }
                filler.add(new Entry(trunkPos, defaultLog));
            }
            i = 0;
            while (MangroveTreeHelper.canPlace(reader, trunkPos = pos.func_177972_a(direction).func_177979_c(++i))) {
                filler.add(new Entry(trunkPos, defaultLog));
                if (i <= reader.func_217301_I()) continue;
                continue block1;
            }
        }
        Direction highestDirection = directions[rand.nextInt(directions.length)];
        boolean failed = false;
        for (Direction direction : directions) {
            int branchCoreOffset = rand.nextInt(MangroveTreeHelper.maximumDownwardsBranchOffset + 1);
            if (direction.equals((Object)highestDirection)) {
                branchCoreOffset = 0;
            } else if (!failed && (double)rand.nextFloat() < 0.25) {
                failed = true;
                continue;
            }
            int branchOffset = MangroveTreeHelper.minimumBranchCoreOffset + rand.nextInt(MangroveTreeHelper.branchCoreOffsetExtra + 1);
            BlockPos branchStartPos = trunkTop.func_177979_c(branchCoreOffset).func_177967_a(direction, branchOffset);
            for (int i = 0; i < branchOffset; ++i) {
                BlockPos branchConnectionPos = branchStartPos.func_177967_a(direction.func_176734_d(), i);
                if (!MangroveTreeHelper.canPlace(reader, branchConnectionPos)) {
                    return false;
                }
                filler.add(new Entry(branchConnectionPos, (BlockState)defaultLog.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k())));
            }
            int branchHeight = MangroveTreeHelper.minimumBranchHeight + rand.nextInt(MangroveTreeHelper.branchHeightExtra + 1);
            for (int i = 0; i <= branchHeight; ++i) {
                BlockPos branchPos = branchStartPos.func_177981_b(i);
                if (!MangroveTreeHelper.canPlace(reader, branchPos)) {
                    return false;
                }
                filler.add(new Entry(branchPos, defaultLog));
            }
            MangroveTreeHelper.makeLeafBlob(leavesFiller, rand, branchStartPos, branchHeight);
        }
        MangroveTreeHelper.fill(reader, filler);
        MangroveTreeHelper.fillLeaves(reader, rand, leavesFiller);
        return true;
    }
}

